//----------------------------------------------------------------------------//
//- CadBoersenStart.pas ------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dialog zur Eingabe der Brsendaten vor dem Start einer Brse               //
// -> Abgeleitet von TCaDlgBaseDialog                                         //
//----------------------------------------------------------------------------//

unit CadBoersenStart;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, ComCtrls, Spin, ExtCtrls, CaoBoersenInfo;

//------------------------------------------------------------------------------

type
  TCaDlgBoersenStart = class(TCaDlgBaseDialog)
    m_GrpDatumTitel      : TGroupBox;
    m_GrpAbgaben         : TGroupBox;
    m_EdtTitel           : TEdit;
    m_LblTitel           : TLabel;
    m_LblDatum           : TLabel;
    m_DtpDatum           : TDateTimePicker;
    m_ChkPozent          : TCheckBox;
    m_SpeAbgabenProzent  : TSpinEdit;
    m_ChkBetrag          : TCheckBox;
    m_EdtBetrag          : TEdit;
    m_ImgBoerseStart     : TImage;

    //--------------------------------------------------------------------------

    procedure BtnPasswortAendernClick (Sender: TObject);
    procedure FormShow                (Sender: TObject);
    procedure ChkPozentClick          (Sender: TObject);
    procedure ChkBetragClick          (Sender: TObject);
    procedure EdtBetragChange         (Sender: TObject);
    procedure FormCloseQuery          (Sender: TObject; var CanClose: Boolean);

  //----------------------------------------------------------------------------

  private
    m_obBoersenInfo: TCaoBoersenInfo;

    //--------------------------------------------------------------------------

    procedure PrvInitValues;
    procedure PrvSetCaptions;
    procedure PrvLoadData;
    procedure PrvSaveData;

  //----------------------------------------------------------------------------

  public
    function  ShowModal(var obBoersenInfo: TCaoBoersenInfo): Integer; reintroduce;
    procedure InitForm;

  //----------------------------------------------------------------------------

  end; // TCaDlgBoersenStart

//------------------------------------------------------------------------------

var
  CaDlgBoersenStart: TCaDlgBoersenStart;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CadPasswortAendern, CamConst;

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.BtnPasswortAendernClick(Sender: TObject);
(*
  Wird der "Passwortndern-Button" gedrckt, so erscheint der "Passwortndern-
  Dialog"
*)
begin
  CaDlgPasswortAendern.ShowModal;
end; // TCaDlgBoersenStart.BtnPasswortAendernClick

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.FormShow(Sender: TObject);
begin
  PrvLoadData;
  PrvSetCaptions;
  // Sind die Abgaben in Prozent > 0 wird das Hklein in der Checkbox gesetzt
  m_ChkPozent.Checked          := m_SpeAbgabenProzent.Value  > 0;
  // Sind die Abgaben in Betrag > 0 wird das Hklein in der Checkbox gesetzt
  m_ChkBetrag.Checked          := StrToFloat(m_EdtBetrag.Text) > 0;
  // Das Defaultdatum ist das aktuelle Datum
  m_DtpDatum.DateTime          := Now;
  PrvInitValues;
  m_EdtTitel.SetFocus;
  inherited;
end; // TCaDlgBoersenStart.FormShow

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.PrvInitValues;
(*
  Steuert die Edit-Felder auf dem Formular. -> Eingaben mglich oder nicht
*)
begin
  // Je nachdem, ob in einer Checkbox ein Hklein gesetzt ist oder nicht, ist
  // das Editieren der dazugehrenden Edits mglich oder nicht,
  m_SpeAbgabenProzent.Enabled  := m_ChkPozent.Checked;
  m_EdtBetrag.Enabled          := m_ChkBetrag.Checked;
end; // TCaDlgBoersenStart.PrvInitValues

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.ChkPozentClick(Sender: TObject);
begin
  inherited;
  PrvInitValues;
end; // TCaDlgBoersenStart.ChkPozentClick

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.ChkBetragClick(Sender: TObject);
begin
  inherited;
  PrvInitValues;
end; // TCaDlgBoersenStart.ChkBetragClick

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.PrvSetCaptions;
(*
  Setzen der Titel im Dialog die mehrfach verwendet werden
*)
begin
  m_GrpDatumTitel.Caption := c_sBoerseBoersendaten;
  m_LblTitel.Caption      := c_sBoerseName;
  m_LblDatum.Caption      := c_sBoerseDatum;
  m_GrpAbgaben.Caption    := c_sBoerseAbgaben;
  m_ChkPozent.Caption     := c_sBoerseAbgabenProzent;
  m_ChkBetrag.Caption     := c_sBoerseAbgabenBetrag;
end; // TCaDlgBoersenStart.PrvSetCaptions

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.EdtBetragChange(Sender: TObject);
begin
  inherited;
  m_obCaoCheck.EditWithNumbers(m_EdtBetrag, True);
end; // TCaDlgBoersenStart.EdtBetragChange

//------------------------------------------------------------------------------

function TCaDlgBoersenStart.ShowModal(var obBoersenInfo: TCaoBoersenInfo): Integer;
begin
  m_obBoersenInfo := obBoersenInfo;
  Result := inherited ShowModal;
end; // TCaDlgBoersenStart.ShowModal

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.PrvLoadData;
begin
  m_ChkPozent.Checked       := True;
  m_ChkBetrag.Checked       := True;
  m_EdtTitel.Text           := '';
  m_SpeAbgabenProzent.Value := 0;
  m_EdtBetrag.Text          := '0.00';
  m_DtpDatum.DateTime       := Now;
end; // TCaDlgBoersenStart.PrvLoadData

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.PrvSaveData;
begin
  if m_ChkPozent.Checked then begin
    m_obBoersenInfo.dAbgabeProzent := m_SpeAbgabenProzent.Value;
  end // if
  else begin
    m_obBoersenInfo.dAbgabeProzent := 0;
  end; // else
  if m_ChkBetrag.Checked then begin
    m_obBoersenInfo.dAbgabeBetrag  := StrToFloat(m_EdtBetrag.Text);
  end // if
  else begin
    m_obBoersenInfo.dAbgabeBetrag := 0;
  end; // else
  m_obBoersenInfo.sTitel         := m_EdtTitel.Text;
  m_obBoersenInfo.dtBoersenDatum := m_DtpDatum.DateTime;
end; // TCaDlgBoersenStart.PrvSaveData

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  inherited;
  if CanClose and (ModalResult <> mrCancel) then begin
    PrvSaveData;
    m_obBoersenInfo.iStatus := c_iModusEdit;
    m_obBoersenInfo.SaveToDb;
  end; // if
end; // TCaDlgBoersenStart.FormCloseQuery

//------------------------------------------------------------------------------

procedure TCaDlgBoersenStart.InitForm;
begin
  m_EdtTitel.Clear;
  m_DtpDatum.DateTime := Now;
  m_SpeAbgabenProzent.Value := 0;
  m_EdtBetrag.Clear;
  m_ChkPozent.Checked := False;
  m_ChkBetrag.Checked := False;
end; // TCaDlgBoersenStart.InitForm

//------------------------------------------------------------------------------

end. // CadBoersenStart
